/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.cultivation.item;

import cofh.core.util.ProxyUtils;
import cofh.core.util.helpers.ChatHelper;
import cofh.core.util.helpers.FluidHelper;
import cofh.lib.item.IColorableItem;
import cofh.lib.item.IMultiModeItem;
import cofh.lib.util.RayTracer;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.AugmentableHelper;
import cofh.thermal.core.config.ThermalCoreConfig;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.item.FluidContainerItemAugmentable;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.tuple.Triple;

public class WateringCanItem
extends FluidContainerItemAugmentable
implements IColorableItem,
DyeableLeatherItem,
IMultiModeItem {
    private static final Set<Triple<BlockPos, BlockState, Block>> WATERED_BLOCKS = new ObjectOpenHashSet();
    protected static final int MB_PER_USE = 50;
    public static boolean allowFakePlayers = false;
    public static boolean removeSourceBlocks = true;
    protected static final Set<Block> EFFECTIVE_BLOCKS = new ObjectOpenHashSet();

    public WateringCanItem(Item.Properties builder, int fluidCapacity) {
        super(builder, fluidCapacity, FluidHelper.IS_WATER);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("color"), (stack, world, entity, seed) -> this.m_41113_(stack) ? 1.0f : 0.0f);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("state"), (stack, world, entity, seed) -> (this.getFluidAmount(stack) > 0 ? 0.5f : 0.0f) + (this.hasActiveTag(stack) ? 0.25f : 0.0f));
        ProxyUtils.registerColorable((Item)this);
        this.numSlots = () -> ThermalCoreConfig.toolAugments;
        this.augValidator = ThermalAugmentRules.createAllowValidator((String[])new String[]{"Upgrade", "Fluid", "Area"});
    }

    protected void tooltipDelegate(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        int radius = this.getMode(stack) * 2 + 1;
        if (radius <= 1) {
            tooltip.add((Component)new TranslatableComponent("info.cofh.single_block").m_130940_(ChatFormatting.ITALIC));
        } else {
            tooltip.add((Component)new TranslatableComponent("info.cofh.area").m_130946_(": " + radius + "x" + radius).m_130940_(ChatFormatting.ITALIC));
        }
        if (this.getNumModes(stack) > 1) {
            this.addModeChangeTooltip(this, stack, worldIn, tooltip, flagIn);
        }
        super.tooltipDelegate(stack, worldIn, tooltip, flagIn);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && (slotChanged || this.getFluidAmount(oldStack) > 0 != this.getFluidAmount(newStack) > 0 || this.getFluidAmount(newStack) > 0 && this.hasActiveTag(oldStack) != this.hasActiveTag(newStack));
    }

    public int m_142159_(ItemStack stack) {
        return 4219135;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos offsetPos;
        BlockHitResult traceResult;
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        if (player == null || Utils.isFakePlayer((Entity)player) && !allowFakePlayers) {
            return InteractionResult.FAIL;
        }
        if (player.m_36341_() && (traceResult = RayTracer.retrace((Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY)).m_6662_() != HitResult.Type.MISS && FluidHelper.isWater((BlockState)world.m_8055_(traceResult.m_82425_()))) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(context.m_43724_());
        BlockPos blockPos = offsetPos = world.m_8055_(pos).m_60815_() ? pos.m_142300_(context.m_43719_()) : pos;
        if (this.getFluidAmount(stack) < this.getWaterPerUse(stack)) {
            return InteractionResult.FAIL;
        }
        this.setActive(stack, (LivingEntity)player);
        int radius = this.getMode(stack);
        int x = offsetPos.m_123341_();
        int y = offsetPos.m_123342_();
        int z = offsetPos.m_123343_();
        for (int i = x - radius; i <= x + radius; ++i) {
            for (int k = z - radius; k <= z + radius; ++k) {
                Utils.spawnParticles((Level)world, (ParticleOptions)ParticleTypes.f_123804_, (double)((double)i + world.f_46441_.nextDouble()), (double)((double)(y - 1) + world.f_46441_.nextDouble()), (double)((double)k + world.f_46441_.nextDouble()), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
            }
        }
        Iterable area = BlockPos.m_121940_((BlockPos)offsetPos.m_142082_(-radius, -2, -radius), (BlockPos)offsetPos.m_142082_(radius, 1, radius));
        for (BlockPos scan : area) {
            BlockState state = world.m_8055_(scan);
            if (!(state.m_60734_() instanceof FarmBlock) || (Integer)state.m_61143_((Property)FarmBlock.f_53243_) >= 7) continue;
            world.m_46597_(scan, (BlockState)state.m_61124_((Property)FarmBlock.f_53243_, (Comparable)Integer.valueOf(7)));
        }
        if (Utils.isServerWorld((Level)world)) {
            if ((double)world.f_46441_.nextFloat() < Math.max((double)this.getEffectiveness(stack), 0.05)) {
                for (BlockPos scan : area) {
                    BlockState plantState = world.m_8055_(scan);
                    Block plant = plantState.m_60734_();
                    if (!(plant instanceof BonemealableBlock) && !(plant instanceof IPlantable) && !EFFECTIVE_BLOCKS.contains(plant)) continue;
                    WATERED_BLOCKS.add((Triple<BlockPos, BlockState, Block>)Triple.of((Object)new BlockPos((Vec3i)scan), (Object)plantState, (Object)plant));
                }
            }
            if (!player.f_36077_.f_35937_) {
                this.drain(stack, this.getWaterPerUse(stack) * (this.getMode(stack) + 1) * 2, IFluidHandler.FluidAction.EXECUTE);
            }
        }
        return InteractionResult.FAIL;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        BlockHitResult traceResult = RayTracer.retrace((Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        ItemStack stack = player.m_21120_(hand);
        if (traceResult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        BlockPos tracePos = traceResult.m_82425_();
        if (!player.m_36341_() || !world.m_7966_(player, tracePos) || Utils.isFakePlayer((Entity)player) && !allowFakePlayers) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (FluidHelper.isWater((BlockState)world.m_8055_(tracePos)) && this.getSpace(stack) > 0) {
            if (removeSourceBlocks) {
                world.m_7731_(tracePos, Blocks.f_50016_.m_49966_(), 11);
            }
            this.fill(stack, new FluidStack((Fluid)Fluids.f_76193_, 1000), IFluidHandler.FluidAction.EXECUTE);
            player.m_5496_(SoundEvents.f_11781_, 1.0f, 1.0f);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!this.hasActiveTag(stack)) {
            return;
        }
        long activeTime = stack.m_41784_().m_128454_("Active");
        if (entityIn.f_19853_.m_46467_() > activeTime) {
            stack.m_41784_().m_128473_("Active");
        }
    }

    protected void setAttributesFromAugment(ItemStack container, CompoundTag augmentData) {
        CompoundTag subTag = container.m_41737_("Properties");
        if (subTag == null) {
            return;
        }
        AugmentableHelper.setAttributeFromAugmentAdd((CompoundTag)subTag, (CompoundTag)augmentData, (String)"Radius");
        super.setAttributesFromAugment(container, augmentData);
    }

    protected float getEffectiveness(ItemStack stack) {
        return 0.4f * this.getBaseMod(stack) - 0.05f * (float)this.getMode(stack);
    }

    protected int getRadius(ItemStack stack) {
        return (int)AugmentableHelper.getPropertyWithDefault((ItemStack)stack, (String)"Radius", (float)0.0f) + 1;
    }

    protected int getWaterPerUse(ItemStack stack) {
        return 50;
    }

    public void updateAugmentState(ItemStack container, List<ItemStack> augments) {
        super.updateAugmentState(container, augments);
        if (this.getMode(container) >= this.getNumModes(container)) {
            this.setMode(container, this.getNumModes(container) - 1);
        }
    }

    public int getColor(ItemStack item, int colorIndex) {
        if (colorIndex == 0) {
            CompoundTag nbt = item.m_41737_("display");
            return nbt != null && nbt.m_128425_("color", 99) ? nbt.m_128451_("color") : 0xFFFFFF;
        }
        return 0xFFFFFF;
    }

    public int getNumModes(ItemStack stack) {
        return 1 + this.getRadius(stack);
    }

    public void onModeChange(Player player, ItemStack stack) {
        player.f_19853_.m_5594_(null, player.m_142538_(), SoundEvents.f_11778_, SoundSource.PLAYERS, 0.6f, 1.0f - 0.1f * (float)this.getMode(stack));
        int radius = this.getMode(stack) * 2 + 1;
        if (radius <= 1) {
            ChatHelper.sendIndexedChatMessageToPlayer((Player)player, (Component)new TranslatableComponent("info.cofh.single_block"));
        } else {
            ChatHelper.sendIndexedChatMessageToPlayer((Player)player, (Component)new TranslatableComponent("info.cofh.area").m_130946_(": " + radius + "x" + radius));
        }
    }

    public static void growPlants(Level world) {
        if (WATERED_BLOCKS.isEmpty()) {
            return;
        }
        for (Triple<BlockPos, BlockState, Block> entry : WATERED_BLOCKS) {
            BlockPos pos = (BlockPos)entry.getLeft();
            BlockState state = (BlockState)entry.getMiddle();
            Block block = (Block)entry.getRight();
            if (block.m_6724_(state)) {
                block.m_7455_(state, (ServerLevel)world, pos, world.f_46441_);
                world.m_7260_(pos, state, state, 3);
                continue;
            }
            world.m_186460_(pos, block, 0);
        }
        WATERED_BLOCKS.clear();
    }

    static {
        EFFECTIVE_BLOCKS.add(Blocks.f_50195_);
        EFFECTIVE_BLOCKS.add(Blocks.f_50491_);
    }
}

